local menuState = {
	CurProfile = 1,
}

-- man this is a hacky workaround...
-- there needs to be a much better way to do this.
local numLocalProfiles = PROFILEMAN:GetNumLocalProfiles()

-- this screen doesn't work without a profile; return something else.
if numLocalProfiles == 0 then
	return Def.ActorFrame{
		Name="NoProfilesWarning";
	};
end

local localProfileIDs = PROFILEMAN:GetLocalProfileIDs()
local localProfileNames = PROFILEMAN:GetLocalProfileDisplayNames()

local localProfiles = {}
for i=1,numLocalProfiles do
	local profID = localProfileIDs[i]
	local profIndex = PROFILEMAN:GetLocalProfileIndexFromID(profID)
	local profile = PROFILEMAN:GetLocalProfileFromIndex(profIndex)
	if profile then
		table.insert(localProfiles, { ID = profID, Name = profile:GetDisplayName(), Profile = profile })
	end
end

local function MakeProfileItem(count,id,name,p)
	if not p then return nil end

	return Def.ActorFrame{
		Name="Profile"..count;
		ProfileChangeMessageCommand=function(self,param)
			local i = self:GetChild("TextItem")
			if		param.OldItem == count then i:playcommand("LoseFocus")
			elseif	param.NewItem == count then i:playcommand("GainFocus")
			end
		end;

		LoadFont("_francophilsans Bold 24px")..{
			Name="TextItem";
			Text=name;
			InitCommand=cmd(shadowlength,2;zoom,20/24);
			BeginCommand=function(self)
				self:playcommand(count == 1 and "GainFocus" or "LoseFocus")
			end;
			GainFocusCommand=cmd(diffuse,color("1,1,1,1"));
			LoseFocusCommand=cmd(diffuse,color("0.625,0.625,0.625,1"));
			OffCommand=cmd(linear,0.2;diffusealpha,0);
		};
	};
end

local function ProfileItems()
	local ret = {}
	local counter = 0
	for k,p in pairs(localProfiles) do
		counter = counter + 1
		table.insert(ret,MakeProfileItem(counter,p.ID,p.Name,p.Profile))
	end
	return ret
end

local moveToNextScreen = false

local t = Def.ActorFrame{
	Def.Actor{
		Name="InputController";
		MenuInputMessageCommand=function(self,param)
			local profileItem = menuState.CurProfile
			if param.Input == "Start" then
				if not moveToNextScreen then
					-- set profile to edit
					setenv("DataPlayerProfile",localProfiles[profileItem].ID)
					-- move to next screen
					moveToNextScreen = true
					SCREENMAN:GetTopScreen():playcommand("Off")
					SCREENMAN:GetTopScreen():PostScreenMessage('SM_GoToNextScreen',0.6);
				end
			else
				local oldItem = profileItem

				if param.Input == "Up" or param.Input == "Left" then
					if profileItem-1 < 1 then
						profileItem = #localProfiles
					else
						profileItem = profileItem - 1
					end
					menuState.CurProfile = profileItem

					MESSAGEMAN:Broadcast("ProfileChange",{ OldItem = oldItem, NewItem = profileItem })
				elseif param.Input == "Down" or param.Input == "Right" then
					if profileItem+1 > #localProfiles then
						profileItem = 1
					else
						profileItem = profileItem + 1
					end
					menuState.CurProfile = profileItem

					MESSAGEMAN:Broadcast("ProfileChange",{ OldItem = oldItem, NewItem = profileItem })
				end
			end
		end;
		MenuUpP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Up", }); end;
		MenuUpP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Up", }); end;
		MenuDownP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Down", }); end;
		MenuDownP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Down", }); end;
		MenuLeftP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Left", }); end;
		MenuLeftP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Left", }); end;
		MenuRightP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Right", }); end;
		MenuRightP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Right", }); end;
		CodeMessageCommand=function(self,param)
			MESSAGEMAN:Broadcast("MenuInput", { Player = param.PlayerNumber, Input = param.Name })
		end;
	};
};

local scroller = Def.ActorScroller{
	InitCommand=cmd(x,SCREEN_CENTER_X-200;CenterY);
	SecondsPerItem=0.2,
	NumItemsToDraw=7,
	TransformFunction = function( self, offset, itemIndex, numItems)
		self:y(24*(itemIndex-(numItems-1)/2))
	end;
	children=ProfileItems(),
}

t[#t+1] = scroller;

local avSize = 24
local ProfileInfo = Def.ActorFrame{
	Name="ProfileInfoSection";
	InitCommand=cmd(x,SCREEN_CENTER_X+108;CenterY);

	-- currently selected profile info
	LoadFont("_francophilsans Bold 24px")..{
		Name="CurProfileText";
		InitCommand=cmd(xy,-152,-76;halign,0;shadowlength,1.5;zoom,20/24);
		BeginCommand=cmd(settext,localProfiles[1].Name);
		ProfileChangeMessageCommand=function(self,param)
			self:settext(localProfiles[param.NewItem].Name)
		end;
		OffCommand=cmd(linear,0.2;diffusealpha,0);
	};
	Def.Sprite{
		InitCommand=cmd(xy,140,-76;);
		BeginCommand=function(self)
			local prof = localProfiles[1]
			local id = prof.ID
			local p = prof.Profile
			local file = p:GetAvatarFilename()
			if file ~= "" then
				local dir = PROFILEMAN:LocalProfileIDToDir(id)
				self:Load(dir..file)
				self:setsize(avSize,avSize)
			else
				self:Load(THEME:GetPathG("","_blank"))
			end
		end;
		ProfileChangeMessageCommand=function(self,param)
			local newProf = localProfiles[param.NewItem]
			local id = newProf.ID
			local p = newProf.Profile
			local file = p:GetAvatarFilename()
			if file ~= "" then
				local dir = PROFILEMAN:LocalProfileIDToDir(id)
				self:Load(dir..file)
				self:setsize(avSize,avSize)
			else
				self:Load(THEME:GetPathG("","_blank"))
			end
		end;
		OffCommand=cmd(linear,0.2;diffusealpha,0);
	};

	Def.Quad{
		Name="Top";
		InitCommand=cmd(y,-61;zoomto,312,2;fadeleft,0.1;faderight,0.1;diffusealpha,0.75/2;blend,Blend.Add);
		OffCommand=cmd(linear,0.2;zoomx,0);
	};
	Def.Quad{
		Name="Mid";
		InitCommand=cmd(y,-60;zoomto,320,2;fadeleft,0.05;faderight,0.05;diffusealpha,0.5);
		OffCommand=cmd(linear,0.2;zoomx,0);
	};
	Def.Quad{
		Name="Bot";
		InitCommand=cmd(y,-59;zoomto,312,1;fadeleft,0.1;faderight,0.1;diffusealpha,0.5);
		OffCommand=cmd(linear,0.2;zoomx,0);
	};

	-- some stats
	LoadFont("_francophilsans Bold 24px")..{
		Name="CurProfileStats";
		InitCommand=cmd(xy,-168,-52;align,0,0;shadowlength,1;zoom,16/24;wrapwidthpixels,344*(24/16));
		BeginCommand=function(self)
			local p = localProfiles[1]
			if p then
				local prof = p.Profile
				self:settext("Songs Played: ".. prof:GetTotalNumSongsPlayed())
			else
				self:settext("no pee")
			end
		end;
		ProfileChangeMessageCommand=function(self,param)
			local p = localProfiles[param.NewItem]
			if p then
				local prof = p.Profile
				self:settext("Songs Played: ".. prof:GetTotalNumSongsPlayed())
			else
				self:settext("no pee")
			end
		end;
		OffCommand=cmd(linear,0.2;diffusealpha,0);
	};
};

table.insert(t,ProfileInfo)

return t